<?php
/**
 * Test script for analytics page
 */

// Include required files
require_once 'admin/config/database.php';
require_once 'admin/includes/functions.php';

echo "Testing analytics data loading...\n";

try {
    // Test MongoDB connection
    $mongoConnection = MongoDBConnection::getInstance();
    $db = $mongoConnection->getDatabase();
    echo "✓ MongoDB connection successful\n";
    
    // Test ping
    $db->command(['ping' => 1]);
    echo "✓ Database ping successful\n";
    
    // Test basic query
    $count = $db->interactions->countDocuments([]);
    echo "✓ Interactions collection accessible, count: $count\n";
    
    // Test analytics data include
    include 'admin/includes/analytics_data.php';
    echo "✓ Analytics data loaded successfully\n";
    
    echo "Analytics stats:\n";
    print_r($analytics_stats);
    
} catch (Exception $e) {
    echo "✗ Error: " . $e->getMessage() . "\n";
    echo "File: " . $e->getFile() . "\n";
    echo "Line: " . $e->getLine() . "\n";
}

