<?php
/**
 * Analytics Page
 */

// Ensure analytics_stats is defined with fallback values
if (!isset($analytics_stats)) {
    $analytics_stats = [
        'total_interactions' => 0,
        'unique_users' => 0,
        'total_recommendations' => 0,
        'avg_ctr' => 0,
        'top_events' => []
    ];
}

// Ensure other variables are defined
if (!isset($daily_trends)) {
    $daily_trends = [];
}
if (!isset($adapter_performance)) {
    $adapter_performance = [];
}
if (!isset($top_content)) {
    $top_content = [];
}
if (!isset($tenants_list)) {
    $tenants_list = [];
}
?>

<div class="page-header">
    <div class="header-content">
        <h2>Analytics & Insights</h2>
        <p class="page-description">Detailed analytics and performance insights</p>
    </div>
    <div class="header-actions">
        <select class="filter-select" style="margin-right: 12px;">
            <option value="7">Last 7 days</option>
            <option value="30">Last 30 days</option>
            <option value="90">Last 90 days</option>
        </select>
        <button class="btn-secondary">
            <i class="fas fa-download"></i>
            Export Report
        </button>
    </div>
</div>

<?php if (isset($error_message)): ?>
    <div class="alert alert-error" style="margin-bottom: 24px;">
        <i class="fas fa-exclamation-triangle"></i>
        <?php echo htmlspecialchars($error_message); ?>
    </div>
<?php endif; ?>

<div class="stats-grid">
    <div class="stat-card">
        <div class="stat-icon">
            <i class="fas fa-mouse-pointer"></i>
        </div>
        <div class="stat-info">
            <h3><?php echo format_number($analytics_stats['total_interactions']); ?></h3>
            <p>Total Interactions</p>
        </div>
    </div>
    
    <div class="stat-card">
        <div class="stat-icon">
            <i class="fas fa-users"></i>
        </div>
        <div class="stat-info">
            <h3><?php echo format_number($analytics_stats['unique_users']); ?></h3>
            <p>Unique Users</p>
        </div>
    </div>
    
    <div class="stat-card">
        <div class="stat-icon">
            <i class="fas fa-magic"></i>
        </div>
        <div class="stat-info">
            <h3><?php echo format_number($analytics_stats['total_recommendations']); ?></h3>
            <p>Recommendations</p>
        </div>
    </div>
    
    <div class="stat-card">
        <div class="stat-icon">
            <i class="fas fa-percentage"></i>
        </div>
        <div class="stat-info">
            <h3><?php echo number_format($analytics_stats['avg_ctr'] * 100, 2); ?>%</h3>
            <p>Average CTR</p>
        </div>
    </div>
</div>

<div class="empty-state" style="padding: 80px 40px; text-align: center;">
    <i class="fas fa-chart-line" style="font-size: 42px; color: #9ca3af; margin-bottom: 20px;"></i>
    <h3 style="font-size: 20px; color: #1f2937; margin-bottom: 12px;">Advanced Analytics Coming Soon</h3>
    <p style="color: #6b7280; font-size: 14px;">Detailed charts, performance metrics, and insights are being developed.</p>
</div>
