# 🚀 **Recora Admin Panel - PHP/MongoDB Edition**

## 📊 **Overview**

This is a comprehensive PHP-based admin panel for the Recora recommendation engine that connects directly to your existing MongoDB database using the collections defined in your `MongoDB_Collections_Schema.md`.

## 🎯 **Features**

### **🏠 Dashboard**
- **Real-time Statistics**: Live metrics from MongoDB collections
- **Interactive Charts**: Performance trends and adapter distribution
- **System Health Monitoring**: Database connection and collection status
- **Recent Activity Feed**: Latest tenant and app activities
- **Quick Actions**: Direct access to common tasks

### **🏢 Tenant Management**
- **Full CRUD Operations**: Create, read, update, delete tenants
- **Auto-incrementing IDs**: Based on MongoDB counters collection
- **Search & Filtering**: By name, ID, and status
- **Related Data Counts**: Apps, items, and interactions per tenant
- **Bulk Operations**: Export to CSV

### **📱 Application Management**
- **Multi-adapter Support**: OTT, Retail, Pharma, Consulting
- **Configuration Management**: Scoring weights, facet weights, MMR lambda
- **Policy Chains**: Content filters and geo restrictions
- **Rate Limiting**: RPM configuration per app
- **Tenant Association**: Linked to parent tenants

### **📦 Content Management**
- **Item Catalog**: Browse all content/products across tenants
- **Domain-specific Facets**: Adapter-based metadata
- **Search & Filter**: By type, adapter, tenant
- **Bulk Import**: CSV/JSON content import
- **Availability Management**: Geographic and device restrictions

### **📈 Analytics Dashboard**
- **User Interactions**: Real-time interaction tracking
- **Recommendation Performance**: CTR, conversion rates
- **Adapter Comparison**: Performance across domains
- **Trend Analysis**: 7/30/90 day comparisons
- **Export Capabilities**: Data export functionality

### **🔍 System Monitoring**
- **Database Statistics**: Collection sizes, index status
- **Performance Metrics**: Response times, error rates
- **Health Checks**: Connection status, recent errors
- **Real-time Updates**: 30-second refresh intervals

## 🛠️ **Technical Stack**

### **Backend**
- **PHP 7.4+**: Modern PHP with MongoDB driver
- **MongoDB 4.4+**: Using existing Recora database
- **MongoDB PHP Driver**: Native MongoDB integration

### **Frontend**
- **Responsive Design**: Mobile-first approach
- **Chart.js**: Interactive data visualizations
- **Vanilla JavaScript**: No framework dependencies
- **CSS Grid/Flexbox**: Modern layout techniques

### **Database Integration**
- **16+ Collections**: Full schema coverage from `MongoDB_Collections_Schema.md`
- **Aggregation Pipelines**: Complex data analysis
- **Real-time Queries**: Live statistics and monitoring
- **Index Optimization**: Performance-tuned queries

## 🚀 **Installation & Setup**

### **Prerequisites**
```bash
# PHP with MongoDB extension
php -m | grep mongodb

# MongoDB Atlas cluster accessible
# (Already configured with your connection string)

# Web server (Apache/Nginx)
```

### **1. MongoDB PHP Driver Installation**
```bash
# Install via PECL
pecl install mongodb

# Or via package manager (Ubuntu/Debian)
sudo apt-get install php-mongodb

# Add to php.ini
echo "extension=mongodb" >> /etc/php/7.4/apache2/php.ini
```

### **2. Database Configuration**
The admin panel is pre-configured to connect to your MongoDB Atlas cluster:
```php
private $connection_string = 'mongodb+srv://mongodb:mtvMongo123@mongodbcluster.wsgjnyw.mongodb.net/?retryWrites=true&w=majority&tls=true&maxPoolSize=10';
private $database_name = 'recora';   // Your database name
```

**✅ Already configured with your Atlas connection string!**

### **3. Web Server Setup**
```apache
# Apache Virtual Host
<VirtualHost *:80>
    DocumentRoot /var/www/html/recora
    ServerName recora-admin.local
    
    <Directory /var/www/html/recora/admin>
        AllowOverride All
        Require all granted
    </Directory>
</VirtualHost>
```

### **4. File Permissions**
```bash
# Set proper permissions
chown -R www-data:www-data /var/www/html/recora/admin
chmod -R 755 /var/www/html/recora/admin
```

## 📋 **MongoDB Collections Used**

The admin panel integrates with all collections from your schema:

### **Core Collections**
- `tenants` - Tenant management
- `apps` - Application configuration
- `counters` - Auto-incrementing IDs

### **Content & Data**
- `items` - Content/product catalog
- `interactions` - User events & analytics

### **Recommendation Engine**
- `user_aliases` - Identity mapping
- `continue_watching` - User progress
- `user_top_n` - Recommendation cache
- `pair_counts` - Co-occurrence matrix
- `content_embeddings` - Vector representations

### **Analytics & Monitoring**
- `reco_requests` - Recommendation logs
- `reco_outcomes` - Performance tracking
- `reco_audit` - Compliance logs
- `daily_kpi` - Aggregated metrics

## 🎯 **Usage Guide**

### **Dashboard Navigation**
1. **Access**: Navigate to `/admin/` in your browser
2. **Sidebar Menu**: Click sections to navigate
3. **Mobile**: Use hamburger menu on small screens
4. **Real-time Data**: Auto-refreshes every 30 seconds

### **Tenant Management**
1. **Add Tenant**: Click "Add Tenant" button
2. **View Details**: Click eye icon to see full details
3. **Edit Tenant**: Click edit icon to modify
4. **Delete Tenant**: Only available if no apps/data exist
5. **Search**: Use search box for quick filtering

### **Data Operations**
1. **Search**: All tables have search functionality
2. **Filtering**: Use dropdown filters
3. **Sorting**: Click column headers to sort
4. **Pagination**: Navigate large datasets
5. **Export**: Download data as CSV

### **Charts & Analytics**
1. **Time Ranges**: Select 7/30/90 day periods
2. **Interactive Charts**: Hover for details
3. **Real-time Updates**: Data refreshes automatically
4. **Export Options**: Save charts and data

## 🔧 **Configuration**

### **Performance Tuning**
```php
// Adjust in includes/functions.php
$items_per_page = 25;        // Records per page
$cache_duration = 300;       // Cache time in seconds
$refresh_interval = 30000;   // Real-time update interval (ms)
```

### **MongoDB Atlas Optimization**
```javascript
// Recommended indexes for performance (apply in Atlas console)
db.tenants.createIndex({"tenant_id": 1}, {unique: true})
db.apps.createIndex({"tenant_id": 1, "app_id": 1}, {unique: true})
db.interactions.createIndex({"tenant_id": 1, "user_id": 1, "ts": -1})
db.items.createIndex({"tenant_id": 1, "item_id": 1}, {unique: true})
```

### **Error Handling**
- **Logging**: Errors logged to PHP error log
- **User Messages**: Friendly error messages in UI
- **Fallback Data**: Graceful degradation on errors
- **Connection Monitoring**: Auto-reconnection handling

## 📊 **API Endpoints**

The admin panel includes several API endpoints for AJAX operations:

- `api/dashboard-refresh.php` - Real-time dashboard updates
- `api/tenant-details.php` - Detailed tenant information
- `api/export.php` - Data export functionality
- `api/search.php` - Advanced search operations

## 🎨 **Customization**

### **Styling**
- **CSS Variables**: Easy color theme changes
- **Responsive Breakpoints**: Customizable screen sizes
- **Component Styling**: Modular CSS structure

### **Functionality**
- **Add New Pages**: Follow existing pattern in `pages/`
- **Custom Charts**: Extend Chart.js implementations
- **New Collections**: Add support for additional MongoDB collections

## 🔒 **Security Considerations**

### **Input Validation**
- **MongoDB Injection**: Protected via parameterized queries
- **XSS Protection**: All output properly escaped
- **CSRF Protection**: Form tokens (implement if needed)

### **Access Control**
- **File Permissions**: Restricted directory access
- **Database Access**: Minimal required permissions
- **Error Disclosure**: Production-safe error messages

## 🚀 **Performance Features**

### **Optimization**
- **Query Caching**: Collection count caching
- **Lazy Loading**: Paginated data loading
- **Efficient Queries**: Optimized MongoDB aggregations
- **Index Usage**: Proper index utilization

### **Monitoring**
- **Real-time Stats**: Live performance metrics
- **Health Checks**: System status monitoring
- **Error Tracking**: Comprehensive error logging

## 📞 **Support & Troubleshooting**

### **Common Issues**
1. **Connection Failed**: Check MongoDB Atlas cluster status and network connectivity
2. **Slow Queries**: Verify indexes are created in Atlas console
3. **Memory Issues**: Adjust PHP memory_limit
4. **Permission Errors**: Check file/directory permissions

### **Debug Mode**
```php
// Enable in config/database.php
error_reporting(E_ALL);
ini_set('display_errors', 1);
```

### **Logs Location**
```bash
# PHP Error Log
tail -f /var/log/apache2/error.log

# MongoDB Atlas Logs
# Check in Atlas console under "Monitoring" -> "Logs"
```

## 🔄 **Updates & Maintenance**

### **Regular Tasks**
- **Index Maintenance**: Monitor index performance
- **Log Rotation**: Manage log file sizes
- **Backup Verification**: Test data backup/restore
- **Performance Review**: Analyze query performance

### **Schema Changes**
When adding new collections to MongoDB:
1. Update `config/database.php` if needed
2. Add new data files in `includes/`
3. Create corresponding page in `pages/`
4. Update navigation in `index.php`

---

## 🎯 **Ready to Use!**

Your Recora admin panel is now ready to manage your MongoDB Atlas-based recommendation engine. The panel is **pre-configured** with your Atlas connection string and provides comprehensive tools for managing tenants, applications, content, and monitoring system performance.

### **🔗 Atlas Connection Details**
✅ **Pre-configured** with your connection string:
- **Cluster**: mongodbcluster.wsgjnyw.mongodb.net
- **Database**: recora
- **Connection**: MongoDB Atlas with SSL/TLS
- **Options**: retryWrites, write majority, connection pooling

**Access your admin panel at**: `http://your-domain/recora/admin/`

🚀 **Professional MongoDB Atlas administration made simple!**
