<?php
/**
 * Recommendations Management Page
 */
?>

<div class="page-header">
    <div class="header-content">
        <h2>Recommendations</h2>
        <p class="page-description">Monitor and manage recommendation requests and outcomes</p>
    </div>
    <div class="header-actions">
        <select class="filter-select" style="margin-right: 12px;">
            <option value="7">Last 7 days</option>
            <option value="30">Last 30 days</option>
            <option value="90">Last 90 days</option>
        </select>
        <button class="btn-secondary">
            <i class="fas fa-download"></i>
            Export Data
        </button>
    </div>
</div>

<div class="stats-grid">
    <div class="stat-card">
        <div class="stat-icon">
            <i class="fas fa-magic"></i>
        </div>
        <div class="stat-info">
            <h3><?php echo format_number($reco_stats['total_requests']); ?></h3>
            <p>Total Requests</p>
        </div>
    </div>
    
    <div class="stat-card">
        <div class="stat-icon">
            <i class="fas fa-check-circle"></i>
        </div>
        <div class="stat-info">
            <h3><?php echo format_number($reco_stats['successful']); ?></h3>
            <p>Successful</p>
        </div>
    </div>
    
    <div class="stat-card">
        <div class="stat-icon">
            <i class="fas fa-clock"></i>
        </div>
        <div class="stat-info">
            <h3><?php echo $reco_stats['avg_response_time']; ?>ms</h3>
            <p>Avg Response Time</p>
        </div>
    </div>
    
    <div class="stat-card">
        <div class="stat-icon">
            <i class="fas fa-percentage"></i>
        </div>
        <div class="stat-info">
            <h3><?php echo number_format($reco_stats['avg_ctr'] * 100, 2); ?>%</h3>
            <p>Average CTR</p>
        </div>
    </div>
</div>

<div class="empty-state" style="padding: 80px 40px; text-align: center;">
    <i class="fas fa-cogs" style="font-size: 42px; color: #9ca3af; margin-bottom: 20px;"></i>
    <h3 style="font-size: 20px; color: #1f2937; margin-bottom: 12px;">Recommendations Management Coming Soon</h3>
    <p style="color: #6b7280; font-size: 14px;">Detailed recommendation tracking and management features are being developed.</p>
</div>
