<?php
/**
 * System Monitoring Page
 */
?>

<div class="page-header">
    <div class="header-content">
        <h2>System Monitoring</h2>
        <p class="page-description">Monitor system health, performance, and resource usage</p>
    </div>
    <div class="header-actions">
        <button class="btn-secondary" onclick="refreshMonitoring()">
            <i class="fas fa-sync-alt"></i>
            Refresh
        </button>
        <button class="btn-primary">
            <i class="fas fa-bell"></i>
            Alerts
        </button>
    </div>
</div>

<!-- System Health Overview -->
<div class="stats-grid">
    <div class="stat-card">
        <div class="stat-icon" style="background: <?php echo $overall_status === 'healthy' ? 'linear-gradient(135deg, #059669, #10b981)' : 'linear-gradient(135deg, #dc2626, #f87171)'; ?>;">
            <i class="fas <?php echo $overall_status === 'healthy' ? 'fa-check' : 'fa-exclamation-triangle'; ?>"></i>
        </div>
        <div class="stat-info">
            <h3 style="color: <?php echo $overall_status === 'healthy' ? '#059669' : '#dc2626'; ?>;">
                <?php echo ucfirst($overall_status); ?>
            </h3>
            <p>System Status</p>
        </div>
    </div>
    
    <div class="stat-card">
        <div class="stat-icon">
            <i class="fas fa-database"></i>
        </div>
        <div class="stat-info">
            <h3><?php echo $system_health['collections_accessible']; ?></h3>
            <p>Collections Active</p>
        </div>
    </div>
    
    <div class="stat-card">
        <div class="stat-icon">
            <i class="fas fa-hdd"></i>
        </div>
        <div class="stat-info">
            <h3><?php echo format_bytes($system_health['database_size']); ?></h3>
            <p>Database Size</p>
        </div>
    </div>
    
    <div class="stat-card">
        <div class="stat-icon">
            <i class="fas fa-exclamation-circle"></i>
        </div>
        <div class="stat-info">
            <h3><?php echo $system_health['recent_errors']; ?></h3>
            <p>Recent Errors</p>
        </div>
    </div>
</div>

<!-- Performance Metrics -->
<div class="data-table-section">
    <div class="table-card">
        <div class="table-header">
            <h3>Performance Metrics (Last 24 Hours)</h3>
        </div>
        <div style="padding: 24px;">
            <div class="stats-grid" style="grid-template-columns: repeat(4, 1fr); gap: 16px;">
                <div style="text-align: center; padding: 16px; background: #f9fafb; border-radius: 8px;">
                    <div style="font-size: 20px; font-weight: 700; color: #1f2937;"><?php echo number_format($performance_metrics['requests_per_hour'], 1); ?></div>
                    <div style="font-size: 13px; color: #6b7280;">Requests/Hour</div>
                </div>
                <div style="text-align: center; padding: 16px; background: #f9fafb; border-radius: 8px;">
                    <div style="font-size: 20px; font-weight: 700; color: #1f2937;"><?php echo number_format($performance_metrics['avg_request_time'], 0); ?>ms</div>
                    <div style="font-size: 13px; color: #6b7280;">Avg Response Time</div>
                </div>
                <div style="text-align: center; padding: 16px; background: #f9fafb; border-radius: 8px;">
                    <div style="font-size: 20px; font-weight: 700; color: <?php echo $performance_metrics['error_rate'] > 5 ? '#dc2626' : '#059669'; ?>;"><?php echo number_format($performance_metrics['error_rate'], 2); ?>%</div>
                    <div style="font-size: 13px; color: #6b7280;">Error Rate</div>
                </div>
                <div style="text-align: center; padding: 16px; background: #f9fafb; border-radius: 8px;">
                    <div style="font-size: 20px; font-weight: 700; color: #1f2937;"><?php echo format_number($active_sessions['unique_users_24h']); ?></div>
                    <div style="font-size: 13px; color: #6b7280;">Active Users</div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Collection Health -->
<div class="data-table-section">
    <div class="table-card">
        <div class="table-header">
            <h3>Collection Health Status</h3>
        </div>
        <div class="table-container">
            <table class="data-table">
                <thead>
                    <tr>
                        <th>Collection</th>
                        <th>Status</th>
                        <th>Documents</th>
                        <th>Size</th>
                        <th>Indexes</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($collection_health as $collection => $health): ?>
                    <tr>
                        <td><strong><?php echo h($collection); ?></strong></td>
                        <td>
                            <span class="status-badge <?php echo $health['status']; ?>">
                                <?php echo ucfirst($health['status']); ?>
                            </span>
                        </td>
                        <td><?php echo format_number($health['document_count']); ?></td>
                        <td><?php echo format_bytes($health['size']); ?></td>
                        <td><?php echo $health['indexes']; ?></td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<!-- Alerts -->
<?php if (!empty($alerts)): ?>
<div class="data-table-section">
    <div class="table-card">
        <div class="table-header">
            <h3>System Alerts</h3>
        </div>
        <div style="padding: 24px;">
            <?php foreach ($alerts as $alert): ?>
            <div class="alert alert-<?php echo $alert['type']; ?>" style="margin-bottom: 12px; padding: 12px 16px; border-radius: 8px; border-left: 4px solid; display: flex; align-items: center; gap: 12px;">
                <i class="fas fa-<?php echo $alert['type'] === 'error' ? 'exclamation-circle' : 'exclamation-triangle'; ?>"></i>
                <span><?php echo h($alert['message']); ?></span>
                <span class="alert-severity" style="margin-left: auto; font-size: 11px; text-transform: uppercase; font-weight: 600;">
                    <?php echo h($alert['severity']); ?>
                </span>
            </div>
            <?php endforeach; ?>
        </div>
    </div>
</div>
<?php endif; ?>

<script>
function refreshMonitoring() {
    showLoading();
    window.location.reload();
}
</script>

<style>
.alert-error {
    background: #fef2f2;
    border-color: #dc2626;
    color: #991b1b;
}

.alert-warning {
    background: #fffbeb;
    border-color: #f59e0b;
    color: #92400e;
}

.status-badge.healthy {
    background: #d1fae5;
    color: #065f46;
}

.status-badge.error {
    background: #fee2e2;
    color: #991b1b;
}
</style>
