<?php
/**
 * Content Items Management Page
 */
?>

<div class="page-header">
    <div class="header-content">
        <h2>Content Management</h2>
        <p class="page-description">Manage content items across all tenants and applications</p>
    </div>
    <div class="header-actions">
        <button class="btn-secondary" onclick="exportData('csv', 'items')">
            <i class="fas fa-download"></i>
            Export CSV
        </button>
        <button class="btn-primary" onclick="openModal('importItemsModal')">
            <i class="fas fa-upload"></i>
            Import Items
        </button>
    </div>
</div>

<div class="stats-grid">
    <div class="stat-card">
        <div class="stat-icon">
            <i class="fas fa-box"></i>
        </div>
        <div class="stat-info">
            <h3><?php echo format_number($item_stats['total']); ?></h3>
            <p>Total Content Items</p>
        </div>
    </div>
    
    <div class="stat-card">
        <div class="stat-icon">
            <i class="fas fa-mouse-pointer"></i>
        </div>
        <div class="stat-info">
            <h3><?php echo format_number($item_stats['with_interactions']); ?></h3>
            <p>With Interactions</p>
        </div>
    </div>
    
    <?php foreach (array_slice($item_stats['by_type'], 0, 2) as $type => $count): ?>
    <div class="stat-card">
        <div class="stat-icon">
            <i class="fas fa-tag"></i>
        </div>
        <div class="stat-info">
            <h3><?php echo format_number($count); ?></h3>
            <p><?php echo ucfirst($type); ?> Items</p>
        </div>
    </div>
    <?php endforeach; ?>
</div>

<div class="empty-state" style="padding: 80px 40px; text-align: center;">
    <i class="fas fa-wrench" style="font-size: 42px; color: #9ca3af; margin-bottom: 20px;"></i>
    <h3 style="font-size: 20px; color: #1f2937; margin-bottom: 12px;">Items Management Coming Soon</h3>
    <p style="color: #6b7280; font-size: 14px;">This page is under development. Content item management features will be available soon.</p>
</div>
