<?php
/**
 * Applications Management Page
 */
?>

<!-- Enhanced Page Header with Summary Stats -->
<div class="apps-page-header">
    <div class="header-main">
        <div class="header-content">
            <h1 class="page-heading">
                <i class="fas fa-mobile-alt"></i>
                Application Management
            </h1>
            <p class="page-description">Manage and monitor applications across all tenants and adapters</p>
        </div>
        <div class="header-actions">
            <button class="btn-outline" onclick="exportData('csv', 'apps')">
                <i class="fas fa-download"></i>
                <span>Export</span>
            </button>
            <button class="btn-gradient" onclick="openModal('addAppModal')">
                <i class="fas fa-plus"></i>
                <span>Add Application</span>
            </button>
        </div>
    </div>
    
    <!-- Statistics Cards -->
    <div class="stats-overview">
        <div class="stat-card total">
            <div class="stat-icon">
                <i class="fas fa-mobile-alt"></i>
            </div>
            <div class="stat-content">
                <span class="stat-number"><?php echo format_number($app_stats['total']); ?></span>
                <span class="stat-label">Total Applications</span>
            </div>
        </div>
        
        <div class="stat-card active">
            <div class="stat-icon">
                <i class="fas fa-check-circle"></i>
            </div>
            <div class="stat-content">
                <span class="stat-number"><?php echo format_number($app_stats['active']); ?></span>
                <span class="stat-label">Active</span>
            </div>
        </div>
        
        <div class="stat-card ott">
            <div class="stat-icon">
                <i class="fas fa-tv"></i>
            </div>
            <div class="stat-content">
                <span class="stat-number"><?php echo format_number($app_stats['ott']); ?></span>
                <span class="stat-label">OTT Apps</span>
            </div>
        </div>
        
        <div class="stat-card retail">
            <div class="stat-icon">
                <i class="fas fa-shopping-cart"></i>
            </div>
            <div class="stat-content">
                <span class="stat-number"><?php echo format_number($app_stats['retail']); ?></span>
                <span class="stat-label">Retail Apps</span>
            </div>
        </div>
    </div>
</div>

<!-- Enhanced Filters and Search Section -->
<div class="filters-search-section">
    <div class="filters-container">
        <div class="filters-header-section">
            <div class="filters-title-area">
                <div class="filters-icon-wrapper">
                    <i class="fas fa-filter"></i>
                </div>
                <div class="filters-title-content">
                    <h2 class="filters-main-title">Filter & Search</h2>
                    <p class="filters-subtitle">Refine your application search with advanced filters</p>
                </div>
            </div>
            <div class="filters-stats">
                <div class="stats-badge">
                    <span class="stats-number"><?php echo format_number($total_apps); ?></span>
                    <span class="stats-label">Total Apps</span>
                </div>
            </div>
        </div>
        
        <div class="filters-form-container">
            <form method="GET" class="enhanced-filters-form">
                <input type="hidden" name="page" value="apps">
                
                <div class="filters-grid-layout">
                    <!-- Search Field -->
                    <div class="filter-field-group search-field">
                        <div class="field-label-section">
                            <div class="field-icon">
                                <i class="fas fa-search"></i>
                            </div>
                            <label class="field-label">Search Applications</label>
                        </div>
                        <div class="search-field-wrapper">
                            <div class="search-input-container">
                                <input type="text" name="search" class="enhanced-search-input" 
                                       placeholder="Search by application name or ID..." 
                                       value="<?php echo h($_GET['search'] ?? ''); ?>">
                                <div class="search-input-icon">
                                    <i class="fas fa-search"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Tenant Filter -->
                    <div class="filter-field-group">
                        <div class="field-label-section">
                            <div class="field-icon">
                                <i class="fas fa-building"></i>
                            </div>
                            <label class="field-label">Tenant</label>
                        </div>
                        <div class="select-field-wrapper">
                            <select name="tenant" class="enhanced-select">
                                <option value="">All Tenants</option>
                                <?php foreach ($tenants_list as $tenant): ?>
                                    <option value="<?php echo h($tenant['tenant_id']); ?>" 
                                            <?php echo ($_GET['tenant'] ?? '') === $tenant['tenant_id'] ? 'selected' : ''; ?>>
                                        <?php echo h($tenant['name']); ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                            <div class="select-arrow">
                                <i class="fas fa-chevron-down"></i>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Adapter Filter -->
                    <div class="filter-field-group">
                        <div class="field-label-section">
                            <div class="field-icon">
                                <i class="fas fa-cogs"></i>
                            </div>
                            <label class="field-label">Adapter Type</label>
                        </div>
                        <div class="select-field-wrapper">
                            <select name="adapter" class="enhanced-select">
                                <option value="">All Adapters</option>
                                <option value="ott" <?php echo ($_GET['adapter'] ?? '') === 'ott' ? 'selected' : ''; ?>>
                                    📺 OTT Platform
                                </option>
                                <option value="retail" <?php echo ($_GET['adapter'] ?? '') === 'retail' ? 'selected' : ''; ?>>
                                    🛒 Retail Commerce
                                </option>
                                <option value="pharma" <?php echo ($_GET['adapter'] ?? '') === 'pharma' ? 'selected' : ''; ?>>
                                    💊 Pharmaceutical
                                </option>
                                <option value="consulting" <?php echo ($_GET['adapter'] ?? '') === 'consulting' ? 'selected' : ''; ?>>
                                    💼 Consulting
                                </option>
                            </select>
                            <div class="select-arrow">
                                <i class="fas fa-chevron-down"></i>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Action Buttons -->
                    <div class="filter-actions-group">
                        <button type="submit" class="filter-apply-btn">
                            <div class="btn-icon">
                                <i class="fas fa-search"></i>
                            </div>
                            <span class="btn-text">Apply Filters</span>
                        </button>
                        <a href="?page=apps" class="filter-reset-btn">
                            <div class="btn-icon">
                                <i class="fas fa-undo"></i>
                            </div>
                            <span class="btn-text">Reset All</span>
                        </a>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Enhanced Applications Overview Section -->
<div class="applications-overview-section">
    <div class="overview-container">
        <div class="overview-header-section">
            <div class="overview-title-area">
                <div class="overview-icon-wrapper">
                    <i class="fas fa-table"></i>
                </div>
                <div class="overview-title-content">
                    <h2 class="overview-main-title">Applications Overview</h2>
                    <p class="overview-subtitle">Complete list of all applications and their performance metrics</p>
                </div>
            </div>
            <div class="overview-controls">
                <div class="results-summary">
                    <div class="results-badge">
                        <span class="results-number"><?php echo count($apps); ?></span>
                        <span class="results-label">Showing</span>
                    </div>
                    <div class="results-divider">of</div>
                    <div class="results-badge total">
                        <span class="results-number"><?php echo format_number($total_apps); ?></span>
                        <span class="results-label">Total</span>
                    </div>
                </div>
                <div class="view-controls">
                    <button class="view-toggle-btn active" data-view="table">
                        <i class="fas fa-table"></i>
                    </button>
                    <button class="view-toggle-btn" data-view="grid">
                        <i class="fas fa-th"></i>
                    </button>
                </div>
            </div>
        </div>
        
        <?php if (!empty($apps)): ?>
            <div class="table-container">
                <table class="data-table">
                    <thead>
                        <tr>
                            <th>App ID</th>
                            <th>Name</th>
                            <th>Tenant</th>
                            <th>Status</th>
                            <th>RPM Limit</th>
                            <th>Created</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($apps as $app): ?>
                            <tr>
                                <td>
                                    <span class="app-id"><?php echo h($app['app_id']); ?></span>
                                </td>
                                <td>
                                    <div class="app-name"><?php echo h($app['name']); ?></div>
                                </td>
                                <td>
                                    <span class="tenant-name"><?php echo h($app['tenant_id']); ?></span>
                                </td>
                                <td>
                                    <span class="status-badge <?php echo $app['status'] === 'active' ? 'active' : 'inactive'; ?>">
                                        <?php echo ucfirst($app['status']); ?>
                                    </span>
                                </td>
                                <td>
                                    <span class="rpm-limit"><?php echo format_number($app['rpm_limit']); ?></span>
                                </td>
                                <td>
                                    <span class="create-date"><?php echo date('M j, Y', strtotime(format_mongo_date($app['created_at']))); ?></span>
                                </td>
                                <td>
                                    <div class="action-buttons">
                                        <button class="btn-action view" title="View" onclick="viewApp('<?php echo h($app['app_id']); ?>')">
                                            <i class="fas fa-eye"></i>
                                        </button>
                                        <button class="btn-action edit" title="Edit" onclick="editApp('<?php echo h($app['app_id']); ?>')">
                                            <i class="fas fa-edit"></i>
                                        </button>
                                        <button class="btn-action delete" title="Delete" onclick="deleteApp('<?php echo h($app['app_id']); ?>', '<?php echo h($app['name']); ?>')">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php else: ?>
            <div class="enhanced-empty-state">
                <div class="empty-state-content">
                    <div class="empty-state-icon">
                        <i class="fas fa-mobile-alt"></i>
                    </div>
                    <h3 class="empty-state-title">No Applications Found</h3>
                    <p class="empty-state-message">
                        <?php if (!empty($_GET['search']) || !empty($_GET['tenant']) || !empty($_GET['adapter'])): ?>
                            No applications match your current search criteria. Try adjusting your filters.
                        <?php else: ?>
                            Get started by adding your first application to the recommendation engine.
                        <?php endif; ?>
                    </p>
                    <div class="empty-state-actions">
                        <?php if (!empty($_GET['search']) || !empty($_GET['tenant']) || !empty($_GET['adapter'])): ?>
                            <a href="?page=apps" class="btn-outline">
                                <i class="fas fa-undo"></i>
                                Clear Filters
                            </a>
                        <?php endif; ?>
                        <button class="btn-gradient" onclick="openModal('addAppModal')">
                            <i class="fas fa-plus"></i>
                            Add New Application
                        </button>
                    </div>
                </div>
            </div>
        <?php endif; ?>
    </div>
</div>

<style>
/* Enhanced Apps Page Styles */

/* Page Header Styles */
.apps-page-header {
    margin-bottom: 32px;
}

.header-main {
    display: flex;
    justify-content: space-between;
    align-items: flex-start;
    margin-bottom: 28px;
    background: linear-gradient(135deg, #fff 0%, #f8fafc 100%);
    padding: 32px;
    border-radius: 16px;
    border: 1px solid #e2e8f0;
    box-shadow: 0 1px 3px rgba(0, 0, 0, 0.05);
}

.header-content {
    flex: 1;
}

.page-heading {
    font-size: 1.875rem;
    font-weight: 800;
    color: #1e293b;
    margin-bottom: 8px;
    display: flex;
    align-items: center;
    gap: 16px;
}

.page-heading i {
    color: #dc2626;
    font-size: 1.875rem;
}

.page-description {
    font-size: 1rem;
    color: #64748b;
    font-weight: 400;
    line-height: 1.5;
}

.header-actions {
    display: flex;
    gap: 12px;
    align-items: center;
}

.btn-outline {
    display: flex;
    align-items: center;
    gap: 8px;
    padding: 12px 20px;
    background: white;
    border: 2px solid #e2e8f0;
    border-radius: 10px;
    color: #475569;
    font-weight: 600;
    text-decoration: none;
    transition: all 0.3s ease;
    cursor: pointer;
}

.btn-outline:hover {
    border-color: #dc2626;
    color: #dc2626;
    background: #fef2f2;
    transform: translateY(-1px);
    box-shadow: 0 4px 12px rgba(220, 38, 38, 0.15);
}

.btn-gradient {
    display: flex;
    align-items: center;
    gap: 8px;
    padding: 12px 24px;
    background: linear-gradient(135deg, #dc2626 0%, #f97316 100%);
    border: none;
    border-radius: 10px;
    color: white;
    font-weight: 600;
    cursor: pointer;
    transition: all 0.3s ease;
    box-shadow: 0 4px 12px rgba(220, 38, 38, 0.3);
}

.btn-gradient:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 20px rgba(220, 38, 38, 0.4);
}

/* Statistics Overview */
.stats-overview {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(240px, 1fr));
    gap: 20px;
}

.stat-card {
    background: white;
    border-radius: 16px;
    padding: 24px;
    border: 1px solid #e2e8f0;
    display: flex;
    align-items: center;
    gap: 20px;
    transition: all 0.3s ease;
    position: relative;
    overflow: hidden;
}

.stat-card::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    height: 3px;
    background: linear-gradient(90deg, transparent, rgba(220, 38, 38, 0.5), transparent);
}

.stat-card:hover {
    transform: translateY(-4px);
    box-shadow: 0 12px 24px rgba(0, 0, 0, 0.1);
}

.stat-card.total::before { background: linear-gradient(90deg, #1e293b, #475569); }
.stat-card.active::before { background: linear-gradient(90deg, #059669, #10b981); }
.stat-card.ott::before { background: linear-gradient(90deg, #3b82f6, #1d4ed8); }
.stat-card.retail::before { background: linear-gradient(90deg, #f59e0b, #fbbf24); }

.stat-icon {
    width: 56px;
    height: 56px;
    border-radius: 14px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1.5rem;
    color: white;
    flex-shrink: 0;
}

.stat-card.total .stat-icon { background: linear-gradient(135deg, #1e293b, #475569); }
.stat-card.active .stat-icon { background: linear-gradient(135deg, #059669, #10b981); }
.stat-card.ott .stat-icon { background: linear-gradient(135deg, #3b82f6, #1d4ed8); }
.stat-card.retail .stat-icon { background: linear-gradient(135deg, #f59e0b, #fbbf24); }

.stat-content {
    flex: 1;
}

.stat-number {
    display: block;
    font-size: 1.5rem;
    font-weight: 800;
    color: #1e293b;
    line-height: 1;
    margin-bottom: 4px;
}

.stat-label {
    font-size: 0.875rem;
    color: #64748b;
    font-weight: 500;
    text-transform: uppercase;
    letter-spacing: 0.025em;
}

/* Enhanced App ID Styling */
.enhanced-app-id {
    background: linear-gradient(135deg, #3b82f6, #1d4ed8);
    color: white;
    padding: 6px 12px;
    border-radius: 8px;
    font-family: 'Inter', 'Lato', 'Monaco', 'Menlo', monospace;
    font-size: 0.875rem;
    font-weight: 600;
    letter-spacing: 0.5px;
}

.tenant-ref {
    color: #6b7280;
    font-family: 'Inter', 'Lato', monospace;
    font-size: 0.875rem;
}

.rpm-limit {
    font-weight: 600;
    color: #059669;
}

/* App Details Cell */
.app-details-cell {
    max-width: 200px;
}

.app-name-primary {
    font-size: 1rem;
    font-weight: 700;
    color: #1e293b;
    margin-bottom: 4px;
    line-height: 1.2;
}

.app-meta-info {
    display: flex;
    align-items: center;
    gap: 8px;
}

.app-id-small {
    font-size: 0.75rem;
    color: #64748b;
    font-family: 'Inter', 'Lato', monospace;
}

/* Adapter Badge Enhancements */
.adapter-badge.ott {
    background: #dbeafe;
    color: #1e40af;
    padding: 4px 8px;
    border-radius: 4px;
    font-size: 0.75rem;
    font-weight: 500;
    text-transform: uppercase;
}

.adapter-badge.retail {
    background: #fef3c7;
    color: #92400e;
    padding: 4px 8px;
    border-radius: 4px;
    font-size: 0.75rem;
    font-weight: 500;
    text-transform: uppercase;
}

.adapter-badge.pharma {
    background: #d1fae5;
    color: #065f46;
    padding: 4px 8px;
    border-radius: 4px;
    font-size: 0.75rem;
    font-weight: 500;
    text-transform: uppercase;
}

.adapter-badge.consulting {
    background: #e0e7ff;
    color: #3730a3;
    padding: 4px 8px;
    border-radius: 4px;
    font-size: 0.75rem;
    font-weight: 500;
    text-transform: uppercase;
}

/* Enhanced Filter & Search Section */
.filters-search-section {
    margin-bottom: 32px;
}

.filters-container {
    background: white;
    border-radius: 20px;
    border: 1px solid #e2e8f0;
    overflow: hidden;
    box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08);
}

.filters-header-section {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 28px 32px;
    background: linear-gradient(135deg, #f8fafc 0%, #f1f5f9 100%);
    border-bottom: 1px solid #e2e8f0;
}

.filters-title-area {
    display: flex;
    align-items: center;
    gap: 20px;
}

.filters-icon-wrapper {
    width: 56px;
    height: 56px;
    background: linear-gradient(135deg, #dc2626, #f97316);
    border-radius: 16px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 1.5rem;
    box-shadow: 0 4px 12px rgba(220, 38, 38, 0.3);
}

.filters-title-content {
    flex: 1;
}

.filters-main-title {
    font-size: 1.125rem;
    font-weight: 700;
    color: #1e293b;
    margin: 0 0 4px 0;
}

.filters-subtitle {
    font-size: 0.75rem;
    color: #64748b;
    margin: 0;
    font-weight: 400;
}

.filters-stats {
    display: flex;
    align-items: center;
}

.stats-badge {
    background: white;
    border: 2px solid #e2e8f0;
    border-radius: 12px;
    padding: 12px 20px;
    display: flex;
    flex-direction: column;
    align-items: center;
    min-width: 80px;
}

.stats-number {
    font-size: 1.25rem;
    font-weight: 700;
    color: #1e293b;
    line-height: 1;
}

.stats-label {
    font-size: 0.75rem;
    color: #64748b;
    font-weight: 500;
    text-transform: uppercase;
    letter-spacing: 0.025em;
    margin-top: 2px;
}

.filters-form-container {
    padding: 32px;
}

.enhanced-filters-form {
    width: 100%;
}

.filters-grid-layout {
    display: grid;
    grid-template-columns: 2fr 1fr 1fr auto;
    gap: 24px;
    align-items: end;
}

.filter-field-group {
    display: flex;
    flex-direction: column;
    gap: 12px;
}

.filter-field-group.search-field {
    grid-column: 1;
}

.field-label-section {
    display: flex;
    align-items: center;
    gap: 10px;
}

.field-icon {
    width: 20px;
    height: 20px;
    background: #f1f5f9;
    border-radius: 6px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: #64748b;
    font-size: 0.75rem;
}

.field-label {
    font-size: 0.875rem;
    font-weight: 600;
    color: #374151;
    margin: 0;
}

.search-field-wrapper {
    position: relative;
}

.search-input-container {
    position: relative;
}

.enhanced-search-input {
    width: 100%;
    padding: 16px 20px 16px 50px;
    border: 2px solid #e2e8f0;
    border-radius: 12px;
    font-size: 1rem;
    background: #f8fafc;
    transition: all 0.3s ease;
    color: #1e293b;
    font-family: 'Inter', 'Lato', sans-serif;
}

.enhanced-search-input:focus {
    outline: none;
    border-color: #dc2626;
    background: white;
    box-shadow: 0 0 0 4px rgba(220, 38, 38, 0.1);
}

.search-input-icon {
    position: absolute;
    left: 18px;
    top: 50%;
    transform: translateY(-50%);
    color: #94a3b8;
    font-size: 1rem;
    pointer-events: none;
}

.select-field-wrapper {
    position: relative;
}

.enhanced-select {
    width: 100%;
    padding: 16px 20px;
    border: 2px solid #e2e8f0;
    border-radius: 12px;
    font-size: 1rem;
    background: #f8fafc;
    color: #1e293b;
    transition: all 0.3s ease;
    cursor: pointer;
    appearance: none;
    font-family: 'Inter', 'Lato', sans-serif;
}

.enhanced-select:focus {
    outline: none;
    border-color: #dc2626;
    background: white;
    box-shadow: 0 0 0 4px rgba(220, 38, 38, 0.1);
}

.select-arrow {
    position: absolute;
    right: 18px;
    top: 50%;
    transform: translateY(-50%);
    color: #94a3b8;
    font-size: 0.875rem;
    pointer-events: none;
}

.filter-actions-group {
    display: flex;
    gap: 12px;
    align-items: center;
}

.filter-apply-btn {
    display: flex;
    align-items: center;
    gap: 10px;
    padding: 16px 24px;
    background: linear-gradient(135deg, #dc2626, #f97316);
    border: none;
    border-radius: 12px;
    color: white;
    font-weight: 600;
    cursor: pointer;
    transition: all 0.3s ease;
    box-shadow: 0 4px 12px rgba(220, 38, 38, 0.3);
}

.filter-apply-btn:hover {
    transform: translateY(-2px);
    box-shadow: 0 6px 16px rgba(220, 38, 38, 0.4);
}

.filter-reset-btn {
    display: flex;
    align-items: center;
    gap: 10px;
    padding: 16px 24px;
    background: white;
    border: 2px solid #e2e8f0;
    border-radius: 12px;
    color: #64748b;
    font-weight: 600;
    text-decoration: none;
    transition: all 0.3s ease;
}

.filter-reset-btn:hover {
    border-color: #64748b;
    color: #374151;
    background: #f8fafc;
    transform: translateY(-1px);
}

.btn-icon {
    display: flex;
    align-items: center;
    justify-content: center;
}

.btn-text {
    font-size: 0.875rem;
}

/* Enhanced Applications Overview Section */
.applications-overview-section {
    margin-bottom: 24px;
}

.overview-container {
    background: white;
    border-radius: 12px;
    border: 1px solid #e2e8f0;
    overflow: hidden;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.06);
}

.overview-header-section {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 20px 24px;
    background: #f8fafc;
    border-bottom: 1px solid #e2e8f0;
}

.overview-title-area {
    display: flex;
    align-items: center;
    gap: 16px;
}

.overview-icon-wrapper {
    width: 40px;
    height: 40px;
    background: linear-gradient(135deg, #3b82f6, #1d4ed8);
    border-radius: 8px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 1rem;
}

.overview-title-content {
    flex: 1;
}

.overview-main-title {
    font-size: 1rem;
    font-weight: 600;
    color: #1e293b;
    margin: 0 0 2px 0;
}

.overview-subtitle {
    font-size: 0.625rem;
    color: #64748b;
    margin: 0;
    font-weight: 400;
}

.overview-controls {
    display: flex;
    align-items: center;
    gap: 16px;
}

.results-summary {
    display: flex;
    align-items: center;
    gap: 8px;
}

.results-badge {
    background: white;
    border: 1px solid #e2e8f0;
    border-radius: 6px;
    padding: 6px 12px;
    display: flex;
    flex-direction: column;
    align-items: center;
    min-width: 50px;
}

.results-badge.total {
    border-color: #dc2626;
    background: #fef2f2;
}

.results-number {
    font-size: 0.875rem;
    font-weight: 600;
    color: #1e293b;
    line-height: 1;
}

.results-badge.total .results-number {
    color: #dc2626;
}

.results-label {
    font-size: 0.625rem;
    color: #64748b;
    font-weight: 500;
    text-transform: uppercase;
    letter-spacing: 0.025em;
    margin-top: 1px;
}

.results-divider {
    font-size: 0.75rem;
    color: #94a3b8;
    font-weight: 500;
}

.view-controls {
    display: flex;
    gap: 4px;
    background: #f1f5f9;
    border-radius: 6px;
    padding: 2px;
}

.view-toggle-btn {
    width: 32px;
    height: 32px;
    border: none;
    background: transparent;
    border-radius: 4px;
    color: #64748b;
    cursor: pointer;
    transition: all 0.2s ease;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 0.75rem;
}

.view-toggle-btn.active {
    background: white;
    color: #dc2626;
    box-shadow: 0 1px 2px rgba(0, 0, 0, 0.1);
}

.view-toggle-btn:hover:not(.active) {
    background: rgba(255, 255, 255, 0.5);
    color: #374151;
}

/* Clean Data Table */
.table-container {
    padding: 0;
    overflow-x: auto;
}

.data-table {
    width: 100%;
    border-collapse: collapse;
    font-size: 0.75rem;
}

.data-table thead {
    background: #f8fafc;
}

.data-table th {
    padding: 12px 16px;
    text-align: left;
    font-weight: 600;
    color: #374151;
    border-bottom: 1px solid #e2e8f0;
    font-size: 0.75rem;
}

.data-table td {
    padding: 12px 16px;
    border-bottom: 1px solid #f1f5f9;
    vertical-align: middle;
}

.data-table tbody tr:hover {
    background: #f8fafc;
}

.app-id {
    font-family: 'Inter', 'Lato', monospace;
    font-size: 0.75rem;
    color: #6b7280;
    background: #f3f4f6;
    padding: 2px 6px;
    border-radius: 4px;
}

.app-name {
    font-weight: 500;
    color: #1f2937;
    font-size: 0.75rem;
}

.tenant-name {
    font-size: 0.75rem;
    color: #6b7280;
}

.status-badge {
    display: inline-block;
    padding: 2px 8px;
    border-radius: 12px;
    font-size: 0.625rem;
    font-weight: 500;
    text-transform: uppercase;
    letter-spacing: 0.025em;
}

.status-badge.active {
    background: #dcfce7;
    color: #166534;
}

.status-badge.inactive {
    background: #fee2e2;
    color: #991b1b;
}

.rpm-limit {
    font-weight: 500;
    color: #1f2937;
    font-size: 0.75rem;
}

.create-date {
    font-size: 0.75rem;
    color: #6b7280;
}

.action-buttons {
    display: flex;
    gap: 4px;
}

.btn-action {
    width: 28px;
    height: 28px;
    border: 1px solid #e2e8f0;
    background: white;
    border-radius: 4px;
    color: #6b7280;
    cursor: pointer;
    transition: all 0.2s ease;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 0.625rem;
}

.btn-action:hover {
    border-color: #d1d5db;
    background: #f9fafb;
    color: #374151;
}

.btn-action.view:hover {
    border-color: #3b82f6;
    color: #3b82f6;
}

.btn-action.edit:hover {
    border-color: #f59e0b;
    color: #f59e0b;
}

.btn-action.delete:hover {
    border-color: #ef4444;
    color: #ef4444;
}

/* Responsive Design */
@media (max-width: 1200px) {
    .filters-grid-layout {
        grid-template-columns: 1fr;
        gap: 20px;
    }
    
    .filter-actions-group {
        justify-content: flex-start;
    }
    
    .overview-controls {
        flex-direction: column;
        gap: 16px;
        align-items: flex-start;
    }
}

@media (max-width: 768px) {
    .filters-header-section,
    .overview-header-section {
        flex-direction: column;
        gap: 20px;
        align-items: flex-start;
    }
    
    .filters-form-container {
        padding: 24px;
    }
    
    .filter-actions-group {
        width: 100%;
        justify-content: stretch;
    }
    
    .filter-apply-btn,
    .filter-reset-btn {
        flex: 1;
        justify-content: center;
    }
}

@media (max-width: 768px) {
    .header-main {
        flex-direction: column;
        gap: 20px;
    }
    
    .header-actions {
        width: 100%;
        justify-content: flex-start;
    }
    
    .stats-overview {
        grid-template-columns: repeat(2, 1fr);
    }
    
    .enhanced-table-container {
        font-size: 0.875rem;
    }
    
    .app-name-primary {
        font-size: 0.875rem;
    }
    
    .metric-number {
        font-size: 1rem;
    }
}

@media (max-width: 640px) {
    .stats-overview {
        grid-template-columns: 1fr;
    }
    
    .action-buttons-group {
        flex-direction: column;
        gap: 4px;
    }
    
    .action-btn {
        width: 32px;
        height: 32px;
    }
}
</style>

<script>
// Apps management functions
function viewApp(appId) {
    showLoading();
    
    fetch(`api/app-details.php?app_id=${appId}`)
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                document.getElementById('appDetails').innerHTML = data.html;
                openModal('viewAppModal');
            } else {
                showToast(data.message || 'Failed to load app details', 'error');
            }
        })
        .catch(error => {
            showToast('Error loading app details', 'error');
        })
        .finally(() => {
            hideLoading();
        });
}

function editApp(appId) {
    showLoading();
    
    fetch(`api/get-app.php?app_id=${appId}`)
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                const app = data.app;
                document.getElementById('edit_app_id').value = app.app_id;
                document.getElementById('edit_app_name').value = app.name;
                document.getElementById('edit_app_tenant').value = app.tenant_id;
                document.getElementById('edit_app_adapter').value = app.adapter;
                document.getElementById('edit_app_status').value = app.status;
                document.getElementById('edit_app_rpm_limit').value = app.rpm_limit;
                openModal('editAppModal');
            } else {
                showToast(data.message || 'Failed to load app data', 'error');
            }
        })
        .catch(error => {
            showToast('Error loading app data', 'error');
        })
        .finally(() => {
            hideLoading();
        });
}

function deleteApp(appId, appName) {
    if (confirm(`Are you sure you want to delete application "${appName}"? This action cannot be undone.`)) {
        showLoading();
        
        const formData = new FormData();
        formData.append('action', 'delete');
        formData.append('app_id', appId);
        
        fetch('?page=apps', {
            method: 'POST',
            body: formData,
            headers: {
                'X-Requested-With': 'XMLHttpRequest'
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                showToast(data.message, 'success');
                window.location.reload();
            } else {
                showToast(data.message || 'Failed to delete application', 'error');
            }
        })
        .catch(error => {
            showToast('Error deleting application', 'error');
        })
        .finally(() => {
            hideLoading();
        });
    }
}

// Initialize page
document.addEventListener('DOMContentLoaded', function() {
    // Auto-submit filter form on select change
    document.querySelectorAll('.enhanced-select').forEach(select => {
        select.addEventListener('change', function() {
            this.closest('form').submit();
        });
    });
    
    // View toggle functionality
    document.querySelectorAll('.view-toggle-btn').forEach(btn => {
        btn.addEventListener('click', function() {
            const view = this.dataset.view;
            
            // Update active state
            document.querySelectorAll('.view-toggle-btn').forEach(b => b.classList.remove('active'));
            this.classList.add('active');
            
            // Toggle view (placeholder for future grid view implementation)
            if (view === 'table') {
                document.querySelector('.enhanced-table-container').style.display = 'block';
                // Hide grid view if it exists
                const gridView = document.querySelector('.grid-view-container');
                if (gridView) gridView.style.display = 'none';
            } else if (view === 'grid') {
                document.querySelector('.enhanced-table-container').style.display = 'none';
                // Show grid view if it exists
                const gridView = document.querySelector('.grid-view-container');
                if (gridView) gridView.style.display = 'block';
            }
        });
    });
    
    // Action buttons now use onclick handlers directly in HTML
    
    // Enhanced search input functionality
    const searchInput = document.querySelector('.enhanced-search-input');
    if (searchInput) {
        searchInput.addEventListener('input', function() {
            // Add real-time search functionality here if needed
            const value = this.value;
            if (value.length > 2) {
                // Could implement debounced search here
            }
        });
    }
});
</script>
