<?php
/**
 * Recora Admin Dashboard - Main Index
 * MongoDB-based Admin Panel
 */

// Error reporting
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Start session
session_start();

// Include database configuration
require_once 'config/database.php';
require_once 'includes/functions.php';

// Get current page
$page = $_GET['page'] ?? 'dashboard';
$allowed_pages = ['dashboard', 'tenants', 'apps', 'items', 'analytics', 'recommendations', 'monitoring'];

if (!in_array($page, $allowed_pages)) {
    $page = 'dashboard';
}

// Get page title
$page_titles = [
    'dashboard' => 'Dashboard Overview',
    'tenants' => 'Tenant Management', 
    'apps' => 'Application Management',
    'items' => 'Content Management',
    'analytics' => 'Analytics & Insights',
    'recommendations' => 'Recommendations',
    'monitoring' => 'System Monitoring'
];

$page_title = $page_titles[$page] ?? 'Dashboard';

// Include page-specific data
try {
    switch($page) {
        case 'dashboard':
            include 'includes/dashboard_data.php';
            break;
        case 'tenants':
            include 'includes/tenants_data.php';
            break;
        case 'apps':
            include 'includes/apps_data.php';
            break;
        case 'items':
            include 'includes/items_data.php';
            break;
        case 'analytics':
            include 'includes/analytics_data.php';
            break;
        case 'recommendations':
            include 'includes/recommendations_data.php';
            break;
        case 'monitoring':
            include 'includes/monitoring_data.php';
            break;
    }
} catch (Exception $e) {
    $error_message = handleDatabaseError($e);
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Recora Admin - <?php echo htmlspecialchars($page_title); ?></title>
    
    <!-- CSS Files -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&family=Lato:wght@300;400;700;900&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <link rel="stylesheet" href="assets/css/admin.css">
    
    <!-- Chart.js for analytics -->
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
</head>
<body>
    <!-- Sidebar Navigation -->
    <aside class="sidebar">
        <div class="sidebar-header">
            <div class="logo">
                <i class="fas fa-brain"></i>
                <h2>Recora Admin</h2>
            </div>
        </div>
        
        <nav class="sidebar-nav">
            <ul class="nav-menu">
                <li class="nav-item <?php echo $page === 'dashboard' ? 'active' : ''; ?>">
                    <a href="?page=dashboard" class="nav-link">
                        <i class="fas fa-chart-pie"></i>
                        <span>Dashboard</span>
                    </a>
                </li>
                <li class="nav-item <?php echo $page === 'tenants' ? 'active' : ''; ?>">
                    <a href="?page=tenants" class="nav-link">
                        <i class="fas fa-building"></i>
                        <span>Tenants</span>
                    </a>
                </li>
                <li class="nav-item <?php echo $page === 'apps' ? 'active' : ''; ?>">
                    <a href="?page=apps" class="nav-link">
                        <i class="fas fa-mobile-alt"></i>
                        <span>Applications</span>
                    </a>
                </li>
                <li class="nav-item <?php echo $page === 'items' ? 'active' : ''; ?>">
                    <a href="?page=items" class="nav-link">
                        <i class="fas fa-box"></i>
                        <span>Content</span>
                    </a>
                </li>
                <li class="nav-item <?php echo $page === 'analytics' ? 'active' : ''; ?>">
                    <a href="?page=analytics" class="nav-link">
                        <i class="fas fa-chart-line"></i>
                        <span>Analytics</span>
                    </a>
                </li>
                <li class="nav-item <?php echo $page === 'recommendations' ? 'active' : ''; ?>">
                    <a href="?page=recommendations" class="nav-link">
                        <i class="fas fa-magic"></i>
                        <span>Recommendations</span>
                    </a>
                </li>
                <li class="nav-item <?php echo $page === 'monitoring' ? 'active' : ''; ?>">
                    <a href="?page=monitoring" class="nav-link">
                        <i class="fas fa-server"></i>
                        <span>Monitoring</span>
                    </a>
                </li>
            </ul>
        </nav>
        
        <div class="sidebar-footer">
            <div class="connection-status">
                <i class="fas fa-cloud-download-alt"></i>
                <span>Database Connected</span>
            </div>
        </div>
    </aside>

    <!-- Main Content -->
    <main class="main-content">
        <!-- Header -->
        <header class="header">
            <div class="header-left">
                <button class="sidebar-toggle">
                    <i class="fas fa-bars"></i>
                </button>
                <!-- <h1 class="page-title"><?php echo htmlspecialchars($page_title); ?></h1> -->
            </div>
            <div class="header-right">
                <div class="header-info">
                    <span class="current-time" id="currentTime"></span>
                    <span class="database-info">Atlas: recora</span>
                </div>
            </div>
        </header>

        <!-- Page Content -->
        <div class="page-content">
            <?php if (isset($error_message)): ?>
                <div class="alert alert-error">
                    <i class="fas fa-exclamation-triangle"></i>
                    <?php echo htmlspecialchars($error_message); ?>
                </div>
            <?php endif; ?>

            <?php
            // Include the appropriate page content
            $page_file = "pages/{$page}.php";
            if (file_exists($page_file)) {
                include $page_file;
            } else {
                echo "<div class='alert alert-error'>Page not found: {$page}</div>";
            }
            ?>
        </div>
    </main>

    <!-- Loading overlay -->
    <div id="loadingOverlay" class="loading-overlay" style="display: none;">
        <div class="loading-spinner">
            <i class="fas fa-spinner fa-spin"></i>
            <p>Loading...</p>
        </div>
    </div>

    <!-- Toast notifications container -->
    <div id="toastContainer" class="toast-container"></div>

    <!-- JavaScript Files -->
    <script src="assets/js/admin.js"></script>
    
    <script>
        // Initialize page-specific functionality
        document.addEventListener('DOMContentLoaded', function() {
            // Update current time
            function updateTime() {
                const now = new Date();
                document.getElementById('currentTime').textContent = now.toLocaleString();
            }
            updateTime();
            setInterval(updateTime, 1000);

            // Initialize page-specific features
            <?php if ($page === 'analytics'): ?>
                initializeAnalyticsCharts();
            <?php elseif ($page === 'dashboard'): ?>
                initializeDashboardCharts();
            <?php endif; ?>

            // Auto-refresh data every 30 seconds for dashboard
            <?php if ($page === 'dashboard'): ?>
                setInterval(function() {
                    refreshDashboardData();
                }, 30000);
            <?php endif; ?>
        });
    </script>
</body>
</html>
